<?php

namespace App\Controller\Units\Data;

use App\Entity\CardInfo\CardInfoQueryInterface;
use App\Entity\Permissions\Permission;
use App\Entity\Units\UnitID;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;
use OpenApi\Annotations as OA;

/**
 * @OA\Tag(name="Units")
 */
#[Route(path: '/api/units', name: 'units_')]
class UnitCardInfoDataController extends AbstractController
{
    public function __construct(
        private CardInfoQueryInterface $cardInfoQuery
    ) {}

    /**
     * @OA\Get(summary="Show card info")
     */
    #[IsGranted(Permission::PUBLIC_ACCESS)]
    #[Route(path: '/{unitId}/card-info', name: 'show_card_info', methods: ['GET'])]
    public function show(string $unitId): JsonResponse
    {
        return $this->json(
            $this->cardInfoQuery->findCardInfoByUnitId(UnitID::fromString($unitId))
        );
    }
}