<?php

namespace App\Controller\Sliders\Update;

use App\Entity\Permissions\Permission;
use App\Entity\Units\Unit;
use App\Models\Gallery\GalleryPhotosModel;
use App\Models\Sliders\SliderPhotosModel;
use App\Services\Sliders\UploadPhotos;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;
use OpenApi\Annotations as OA;

/**
 * @OA\Tag(name="Sliders")
 */
#[Route(path: '/api', name: 'sliders_')]
class UploadPhotoToSliderController extends AbstractController
{
    public function __construct(
        private UploadPhotos $uploadPhotos
    ) {}

    /**
     * @OA\Post(summary="Upload photo to slider")
     * @OA\RequestBody(
     *     @OA\MediaType(
     *         mediaType="multipart/form-data",
     *         @OA\Schema(
     *             type="object",
     *             @OA\Property(
     *                 property="photos[]",
     *                 type="array",
     *                 @OA\Items(type="file")
     *             )
     *         )
     *     )
     * )
     */
    #[IsGranted(Permission::UNIT_ADMINISTRATION)]
    #[Route(path: '/slider', name: 'upload_slider', methods: ['POST'])]
    public function upload(SliderPhotosModel $sliderPhotosModel): JsonResponse
    {
        $this->uploadPhotos->upload($sliderPhotosModel);
        return $this->json('Photos have been uploaded');
    }
}