<?php

namespace App\Controller\Sliders\Update;

use App\Entity\Permissions\Permission;
use App\Models\Sliders\SliderModel;
use App\Services\Sliders\UpdateSlider;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use OpenApi\Annotations as OA;
use Nelmio\ApiDocBundle\Annotation\Model;

/**
 * @OA\Tag(name="Sliders")
 */
class UpdateSliderController extends AbstractController
{
    public function __construct(
        private UpdateSlider $updateSlider
    ) {}

    /**
     * @OA\Put(summary="Update slider")
     * @OA\RequestBody(
     *     @Model(type=SliderModel::class)
     * )
     */
    #[IsGranted(Permission::UNIT_ADMINISTRATION)]
    #[Route(path: 'api/slider', name: 'slider_update', methods: ['PUT'])]
    public function update(SliderModel $sliderModel): JsonResponse
    {
        $this->updateSlider->update($sliderModel);
        return $this->json('Slider has been updated');
    }

}