<?php

namespace App\Controller\Reports;

use App\Core\ValidatorModel\ValidatorModelInterface;
use App\Entity\Permissions\Permission;
use App\Entity\Reports\ReadModel\ReportsQueryInterface;
use App\Models\Reports\RequestDatesModel;
use OpenApi\Annotations as OA;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

/** @OA\Tag(name="Reports") */
#[Route('/api/reports', name: 'reports_')]
class FinancesReportController extends AbstractController
{
    public function __construct(
        private ReportsQueryInterface $reportsQuery,
        private ValidatorModelInterface $validator
    )
    {
    }

    /**
     * @OA\Get(summary="Get finances report data")
     * @OA\Parameter(name="dateStart", in="query", description="date start")
     * @OA\Parameter(name="dateEnd", in="query", description="date end")
     * @param Request $request
     * @return JsonResponse
     */
    #[IsGranted(Permission::UNIT_ADMINISTRATION)]
    #[Route(path: '/finances', name: 'finances', methods: ['GET'])]
    public function financesReport(Request $request): JsonResponse
    {
        $dateStart = $request->query->get('dateStart');
        $dateEnd = $request->query->get('dateEnd');

        $requestDates = new RequestDatesModel($dateStart, $dateEnd);
        $this->validator->validate($requestDates);

        return $this->json(
            $this->reportsQuery->getFinanceReportData($requestDates)
        );
    }

}