<?php

namespace App\Controller\Posts;

use App\Entity\Permissions\Permission;
use App\Entity\Posts\Post;
use App\Services\Posts\DeletePost;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use OpenApi\Annotations as OA;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @OA\Tag(name="Posts")
 */
#[Route(path: '/api/posts', name: 'posts_')]
class DeletePostController extends AbstractController
{
    public function __construct(
        private DeletePost $deletePost
    ) {}

    /**
     * @OA\Delete(summary="Remove post")
     */
    #[Security("is_granted('ROLE_UNIT_ADMINISTRATION') or is_granted('ROLE_UNIT_REDACTION')")]
    #[Route(path: '/{postId}', name: 'delete', methods: ['DELETE'])]
    #[ParamConverter('post', options: ['mapping' => ['postId' => 'uuid']])]
    public function delete(Post $post): JsonResponse
    {
        $this->deletePost->delete($post);
        return $this->json('Post has been removed');
    }
}