<?php

namespace App\Controller\Photos;

use App\Entity\Images\Image;
use App\Entity\Permissions\Permission;
use App\Services\Galleries\DeletePhoto;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;
use OpenApi\Annotations as OA;

/**
 * @OA\Tag(name="Photos")
 */
#[Route(path: '/api', name: 'photo_')]
class DeleteGalleryPhotoController extends AbstractController
{
    public function __construct(
        private DeletePhoto $deletePhoto
    ) {}

    /**
     * @OA\Delete(summary="Delete gallery photo")
     */
    #[Security("is_granted('ROLE_UNIT_ADMINISTRATION') or is_granted('ROLE_UNIT_REDACTION')")]
    #[Route(path: '/photo/{photoId}', name: 'gallery_delete', methods: ['DELETE'])]
    #[ParamConverter('image', options: ['mapping' => ['photoId' => 'uuid']])]
    public function delete(Image $image): JsonResponse
    {
        $this->deletePhoto->delete($image);
        return $this->json('Photos have been deleted');
    }
}