<?php

namespace App\Controller\Permissions;

use App\Entity\Permissions\Permission;
use App\Entity\Permissions\ReadModel\PermissionsQueryInterface;
use OpenApi\Annotations as OA;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @OA\Tag(name="Permissions")
 */
#[Route(path: '/api/permissions', name: 'permissions_')]
class PermissionDataController extends AbstractController
{
    /**
     * @OA\Get(summary="Permissions list")
     */
    #[IsGranted(Permission::PUBLIC_ACCESS)]
    #[Route(path: '', name: 'list', methods: ['GET'])]
    public function all(PermissionsQueryInterface $permissionsQuery)
    {
        return $this->json($permissionsQuery->getAll());
    }
}