<?php

namespace App\Controller\P24;

use App\PaymentSystem\Przelewy24Interface;
use OpenApi\Annotations as OA;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @OA\Tag(name="P24")
 */
#[Route(path: '/api/', name: '')]
class TestTransactionInfoController extends AbstractController
{
    #[Route('p24/transaction/{sessionId}/get', name: 'transaction_session', methods: ['GET'])]
    public function connect(Przelewy24Interface $przelewy24, int $sessionId): Response
    {
        return $this->json(["response" => $przelewy24->transactionBySessionId($sessionId)]);
    }
}