<?php

namespace App\Controller\Orders\Webhooks;

use App\Entity\Orders\Order;
use App\Services\Orders\Webhooks\VerifyOrder;
use App\Services\Orders\Webhooks\VerifyRenewSubscriptionOrder;
use OpenApi\Annotations as OA;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route(path: '/api/orders', name: 'orders_')]
class VerifyOrderController extends AbstractController
{

    public function __construct(
        private VerifyOrder $verifyOrder,
        private VerifyRenewSubscriptionOrder $verifyRenewSubscriptionOrder
    )
    {
    }

    #[Route('/{orderID}/webhook', name: 'webhook', methods: ['POST'])]
    #[ParamConverter('order', options: ['mapping' => ['orderID' => 'uuid']])]
    public function webhook(Order $order): Response
    {
        $this->verifyOrder->verify($order);

        return $this->json(["Success"]);
    }

    #[Route('/{orderID}/renew-subscription-webhook', name: 'renew_subscription_webhook', methods: ['POST'])]
    #[ParamConverter('order', options: ['mapping' => ['orderID' => 'uuid']])]
    public function renewSubscriptionWebhook(Order $order): Response
    {
        $this->verifyRenewSubscriptionOrder->verifyRenewSubscription($order);

        return $this->json(["Success"]);
    }

}