<?php

namespace App\Controller\Orders\Webhooks;

use App\Entity\Orders\Order;
use App\PaymentSystem\CardInfoNotification;
use App\Services\Orders\Webhooks\CardInfoForOrder;
use OpenApi\Annotations as OA;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route(path: '/api/orders', name: 'orders_')]
class CardInfoNotificationController extends AbstractController
{

    public function __construct(
        private CardInfoForOrder $cardInfo
    )
    {
    }

    #[Route('/{orderID}/card-info', name: 'card_info', methods: ['POST'])]
    #[ParamConverter('order', options: ['mapping' => ['orderID' => 'uuid']])]
    public function webhook(Order $order): Response
    {
        $this->cardInfo->cardInfo($order);

        return $this->json(["Success"]);
    }
}