<?php

namespace App\Command;

use App\Adapter\Subscriptions\Email\SubscriptionNotificationsInterface;
use App\Entity\Subscriptions\SubscriptionsInterface;
use Psr\Log\LoggerInterface;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class SubscriptionRemindEmailCommand extends Command
{
    protected static $defaultName = 'subscription:remind';

    public function __construct(
        private LoggerInterface $mailerLogger,
        private SubscriptionsInterface $subscriptions,
        private SubscriptionNotificationsInterface $subscriptionNotifications
    )
    {
        parent::__construct();
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->mailerLogger->info('Script ' . self::$defaultName . ' start');

        foreach ($this->subscriptions->findAllToRemind() as $subscription) {
            if ($subscription->getUser()->hasSubscriptionExpiringAgreement())
                $this->subscriptionNotifications->sendRemindEmail($subscription);
        }

        $this->mailerLogger->info('Script ' . self::$defaultName . ' end');

        return 1;
    }
}