<?php

namespace App\Adapter\Users;

use App\Entity\Users\User;
use App\Entity\Users\UsersInterface;
use Doctrine\ORM\EntityManagerInterface;

class Users implements UsersInterface
{
    /**
     * Users constructor.
     * @param EntityManagerInterface $entityManager
     */
    public function __construct(
        private EntityManagerInterface $entityManager
    )
    {
    }

    public function add(User $user): void
    {
        $this->entityManager->persist($user);
    }

    public function findOneByEmail(string $email): ?User
    {
        return $this->entityManager->getRepository(User::class)->findOneBy(['email' => $email]);
    }

    public function findOneByToken(?string $token): ?User
    {
        return $this->entityManager->getRepository(User::class)->findOneBy(['referenceCode' => $token]);
    }


    public function generateReferenceCode(int $length = 4): string
    {
        do {
            $random = sprintf("%0{$length}d", mt_rand(0, pow(10, $length) - 1));
        } while (
            $this->findOneByToken($random)
        );

        return $random;
    }
}