<?php

namespace App\Adapter\Subscriptions\Email;

use App\Core\Notification\NotifierManagerInterface;
use App\Entity\Subscriptions\Subscription;

class SubscriptionNotifications implements SubscriptionNotificationsInterface
{
    public function __construct(
        private NotifierManagerInterface $notifier
    )
    {
    }

    public function sendCardChargeErrorEmail(Subscription $subscription): void
    {
        $context = [
            'attempts' => $subscription->getAttempts(),
            'unitTitle' => $subscription->getUnit()->getTitle()
        ];

        $user = $subscription->getUser();

        $unitType = $subscription->getUnit()->getType();
        $subscriptionCardChargeNotificationTemplate = new SubscriptionCardChargeNotificationTemplate($unitType);

        $this->notifier->sendMail($subscriptionCardChargeNotificationTemplate->getSubject(), $context, $subscriptionCardChargeNotificationTemplate->getTemplate(), $user);
    }

    public function sendRemindEmail(Subscription $subscription): void
    {
        $context = [
            'subscription' => $subscription
        ];

        $user = $subscription->getUser();

        $unitType = $subscription->getUnit()->getType();
        $subscriptionRemindNotificationTemplate = new SubscriptionRemindNotificationTemplate($unitType);

        $this->notifier->sendMail($subscriptionRemindNotificationTemplate->getSubject(), $context, $subscriptionRemindNotificationTemplate->getTemplate(), $user);
    }
}