<?php

namespace App\Adapter\Sliders;

use App\Entity\Sliders\Slider;
use App\Entity\Sliders\SliderInterface;
use Doctrine\ORM\EntityManagerInterface;

class Sliders implements SliderInterface
{
    public function __construct(
        private EntityManagerInterface $entityManager
    ) {}

    public function getSlider(): Slider
    {
        $qb = $this->entityManager->createQueryBuilder();

        return $qb
            ->select('s')
            ->from(Slider::class, 's')
            ->setMaxResults(1)
            ->getQuery()
            ->getSingleResult();
    }
}