<?php

namespace App\Adapter\Reports\ReadModel;

use App\Entity\Agreement\Agreement;
use App\Entity\Reports\ReadModel\ReportsSubQueryInterface;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;

class ReportsSubQuery implements ReportsSubQueryInterface
{
    public function __construct(
        private Connection $connection
    )
    {
    }

    public function usersAgreement(string $agreementOriginalName): QueryBuilder
    {
        $qb = $this->connection->createQueryBuilder();

        return $qb
            ->select('u.uuid as user_id')
            ->addSelect('a.uuid as agreement_id')
            ->from('user_agreement', 'uA')
            ->leftJoin('uA', 'user', 'u', 'uA.user_id = u.uuid')
            ->leftJoin('uA', 'agreement', 'a', 'uA.agreement_id = a.uuid')
            ->where('a.original_name =:agreement')
            ->setParameter('agreement', $agreementOriginalName);
    }

}