<?php

namespace App\Adapter\Permissions\ReadModel;

use App\Entity\Permissions\ReadModel\PermissionDTO;
use App\Entity\Permissions\ReadModel\PermissionsQueryInterface;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Exception;

class PermissionsQuery implements PermissionsQueryInterface
{
    public function __construct(
        private Connection $connection
    ) {}

    public function getAll(): array
    {
        $qb = $this->connection->createQueryBuilder();

        $results = $qb
            ->select('p.uuid as uuid')
            ->addSelect('p.name as name')
            ->addSelect('p.authorization as authorization')
            ->from('permission', 'p')
            ->execute()
            ->fetchAllAssociative();

        return array_map(fn($permission) =>  PermissionDTO::fromArray($permission), $results);

    }
}