<?php

namespace App\Adapter\CardInfo\ReadModel;

use App\Entity\CardInfo\CardInfoQueryInterface;
use App\Entity\Units\ReadModel\CardInfoDTO;
use App\Entity\Units\UnitID;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Exception;

class CardInfoQuery implements CardInfoQueryInterface
{
    public function __construct(
        private Connection $connection
    ) {}

    /**
     * @throws Exception
     * @throws \ReflectionException
     */
    public function findCardInfoByUnitId(UnitID $unitID): ?CardInfoDTO
    {
        $qb = $this->connection->createQueryBuilder();

        $result = $qb
            ->select('c.content')
            ->from('unit', 'u')
            ->leftJoin('u', 'content', 'c', 'u.card_id = c.uuid')
            ->where('u.uuid = :unitID')
            ->setParameter('unitID', $unitID, 'uuid')
            ->execute()
            ->fetch();

        return $result ? CardInfoDTO::fromArray($result) : null;
    }
}