<?php

namespace App\Adapter\Agreement;

use App\Entity\Agreement\Agreement;
use App\Entity\Agreement\AgreementID;
use App\Entity\Agreement\ReadModel\AgreementsInterface;
use Doctrine\ORM\EntityManagerInterface;

class Agreements implements AgreementsInterface
{
    public function __construct(
        private EntityManagerInterface $entityManager
    ) {}

    public function findOneById(AgreementID $agreementID): ?Agreement
    {
        return $this->entityManager
            ->getRepository(Agreement::class)
            ->findOneBy([
                'uuid' => $agreementID
            ]);
    }

    public function findAgreementsToAssign(array $agreementOriginalNames): array
    {
        $qb = $this->entityManager->createQueryBuilder();

        return $qb
            ->select('a')
            ->from(Agreement::class, 'a')
            ->where('a.isRequired = :status')
            ->orWhere($qb->expr()->in('a.originalName', ':originalNames'))
            ->setParameter('status', true)
            ->setParameter('originalNames', $agreementOriginalNames)
            ->getQuery()
            ->execute();
    }

    public function findAllByIDs(array $agreementIDs): array
    {
        $qb = $this->entityManager->createQueryBuilder();

        return $qb
            ->select('a')
            ->from(Agreement::class, 'a')
            ->where($qb->expr()->in('a.uuid', ':agreementIDs'))
            ->setParameter('agreementIDs', array_map(fn($agreementID) => $agreementID->toBinary(), $agreementIDs))
            ->getQuery()
            ->execute();
    }
}