<?php

namespace App\Services\Users;

use App\Core\Transactions\TransactionInterface;
use App\Entity\Subscriptions\Classes\SubscriptionManagerInterface;
use App\Entity\Subscriptions\Helper\ReasonForClosure;
use App\Entity\Subscriptions\SubscriptionsInterface;
use App\Entity\Users\User;
use App\Models\Users\UserStatusModel;

class UpdateUserStatus
{
    public function __construct(
        private TransactionInterface $transaction,
        private SubscriptionManagerInterface $subscriptionManager
    )
    {
    }

    public function block(User $user): void
    {
        $this->transaction->begin();

        $user->block();
        $this->subscriptionManager->deactivateSubscriptionsByUser($user);

        $this->transaction->end();
    }

    public function unblock(User $user)
    {
        $this->transaction->begin();

        $user->unblock();

        $this->transaction->end();
    }
}