<?php

namespace App\Services\Users;

use App\Core\Transactions\TransactionInterface;
use App\Entity\Roles\Role;
use App\Entity\Users\User;
use App\Entity\Users\UsersInterface;

class UpdateUserRole
{
    public function __construct(
        private TransactionInterface $transaction,
        private UsersInterface $users
    )
    {
    }

    public function editUserRole(User $user, Role $role): void
    {
        $this->transaction->begin();

        $user->updateRole($role);

        if ($role->isVolunteer())
            $user->setReferenceCode($this->users->generateReferenceCode());

        $this->transaction->end();
    }
}