<?php

namespace App\Services\Users;

use App\Adapter\Users\Email\UserNotificationsInterface;
use App\Core\Exception\ApiException;
use App\Core\Transactions\TransactionInterface;
use App\Entity\Agreement\ReadModel\AgreementsInterface;
use App\Entity\Roles\Role;
use App\Entity\Roles\RolesInterface;
use App\Entity\Users\Factory\UserFactory;
use App\Entity\Users\User;
use App\Entity\Users\UsersInterface;
use App\Models\Users\UserModel;
use Symfony\Contracts\Translation\TranslatorInterface;

class CreateUser
{
    public function __construct(
        private TranslatorInterface $translator,
        private TransactionInterface $transaction,
        private UsersInterface $users,
        private UserFactory $userFactory,
        private AgreementsInterface $agreements,
        private RolesInterface $rolesQuery,
        private UserNotificationsInterface $notifications
    ) {}

    /** @throws ApiException */
    public function create(UserModel $userModel)
    {
        if ($this->users->findOneByEmail($userModel->getEmail())) {
            throw new ApiException($this->translator->trans('exception.user_exist'));
        }

        $this->transaction->begin();

        $userRole = $this->rolesQuery->findOneRoleByOriginalName(Role::USER);
        $user = $this->userFactory->buildUser($userModel, $userRole);
        $this->assignRequiredAgreements($user, $userModel->getAgreementOriginalNames());

        $this->users->add($user);
        $this->notifications->sendActivationEmail($user);

        $this->transaction->end();
    }

    private function assignRequiredAgreements(User $user, array $agreementOriginalNames): void
    {
        $agreements = $this->agreements->findAgreementsToAssign($agreementOriginalNames);

        foreach ($agreements as $agreement) {
            $user->addAgreement($agreement);
        }
    }
}