<?php

namespace App\Services\Sliders;

use App\Core\File\FileToUpload\FileToUploadInterface;
use App\Core\File\SliderImageManager\SliderImageManagerInterface;
use App\Core\Transactions\TransactionInterface;
use App\Entity\SliderImages\SliderImagesInterface;
use App\Models\Sliders\SliderPhotosModel;

class UploadPhotos
{
    public function __construct(
        private TransactionInterface $transaction,
        private SliderImagesInterface $sliderImages,

        private SliderImageManagerInterface $sliderImageManager
    ) {}

    public function upload(SliderPhotosModel $sliderPhotosModel): void
    {
        $this->transaction->begin();

        /** @var FileToUploadInterface $sliderPhoto */
        foreach ($sliderPhotosModel->getPhotos() as $sliderPhoto) {
            $photo = $this->sliderImageManager->prepare(imageToUpload: $sliderPhoto);

            $this->sliderImages->add($photo);
        }

        $this->transaction->end();
    }
}