<?php

namespace App\Services\Sliders;

use App\Core\Transactions\TransactionInterface;

use App\Entity\SliderImages\SliderImageID;
use App\Entity\SliderImages\SliderImagesInterface;
use App\Entity\Sliders\ReadModel\SliderQueryInterface;
use App\Entity\Sliders\SliderInterface;
use App\Entity\Sliders\Slider;
use App\Entity\Units\UnitsInterface;
use App\Models\SliderImages\SliderImageModel;
use App\Models\Sliders\SliderModel;

class UpdateSlider
{
    public function __construct(
        private TransactionInterface $transaction,
        private SliderInterface $slider,
        private SliderImagesInterface $sliderImages,
        private UnitsInterface $units
    ) {}

    public function update(SliderModel $sliderModel): void
    {
        $slider = $this->slider->getSlider();

        $this->transaction->begin();

        $slider->setDurationTime(
            $sliderModel->getDurationTime()
        );

       $photos = $sliderModel->getPhotos();
       $sliderImagesToUpdate = $this->sliderImages->findAllByIDs($sliderModel->getPhotosIDs());

       foreach ($sliderImagesToUpdate as $sliderImage)
       {
           $newSliderImage = $this->getValuesToUpdate($sliderImage->getUuid(),$photos);
            $sliderImage->setOrderNumber($newSliderImage->getOrderNumber());
            $sliderImage->setUnit(
                $newSliderImage->getUnitId() ? $this->units->findOneByUnitID($newSliderImage->getUnitId()) : null);
            $sliderImage->setDescription($newSliderImage->getDescription());
            $sliderImage->setTitle($newSliderImage->getTitle());
       }

        $this->transaction->end();
    }

    public function getValuesToUpdate(SliderImageID $sliderImageID, array $photos): ?SliderImageModel
    {
        foreach ($photos as $photo)
        {
            if ($photo->getPhotoId() === (string) SliderImageID::fromString($sliderImageID))
            {
                return $photo;
            }
        }
        return null;
    }
}