<?php

namespace App\Services\Sliders;

use App\Core\File\FileRemover\FileRemoverInterface;
use App\Core\Transactions\TransactionInterface;
use App\Entity\SliderImages\SliderImage;
use App\Entity\SliderImages\SliderImagesInterface;
use App\Entity\Sliders\ReadModel\SliderQueryInterface;
use App\Entity\Sliders\SliderInterface;

class DeletePhoto
{
    public function __construct(
        private TransactionInterface $transaction,
        private FileRemoverInterface $fileRemover,
        private SliderImagesInterface $sliderImages,
        private SliderInterface $slider,
    ) {}

    public function delete(SliderImage $sliderImage): void
    {
        $this->transaction->begin();

        $this->fileRemover->remove($sliderImage->getImage());

        $sliderImagesToUpdate = $this->sliderImages->getSliderImagesWithOrderNumberBiggerThan(
            $this->slider->getSlider()->getUuid(),
            $sliderImage->getOrderNumber());

        $this->sliderImages->remove($sliderImage);

        foreach ($sliderImagesToUpdate as $sliderImage)
        {
            $sliderImage->decreaseOrderNumber();
        }

        $this->transaction->end();
    }
}