<?php

namespace App\Services\Orders;

use App\Core\Transactions\TransactionInterface;
use App\Entity\Subscriptions\Helper\ReasonForClosure;
use App\Entity\Subscriptions\Subscription;

class SubscriptionCancel
{
    public function __construct(
        private TransactionInterface $transaction,
    )
    {
    }

    public function cancel(Subscription $subscription)
    {
        $this->transaction->begin();

        $subscription->deactivate(ReasonForClosure::CANCEL);

        $this->transaction->end();

    }
}