<?php

namespace App\Services\Orders;

use App\Core\Transactions\TransactionInterface;
use App\Entity\Orders\Classes\OrderManagerInterface;
use App\Entity\Orders\OrdersInterface;
use App\Entity\Units\Unit;
use App\Models\Orders\OrderPurposeModel;
use App\PaymentSystem\PaymentTransaction;
use App\PaymentSystem\Przelewy24Interface;

class CreateOrderForPurposePayment
{

    public function __construct(
        private TransactionInterface $transaction,
        private Przelewy24Interface $p24,
        private OrderManagerInterface $orderManager,
        private OrdersInterface $orders,
    )
    {
    }

    public function purposeOrder(OrderPurposeModel $orderPurposeModel, Unit $unit): string
    {
        $order = $this->orderManager->createPurposeOrder( $orderPurposeModel->getEmail(), $orderPurposeModel->getAmount(), $unit, $orderPurposeModel->getUser());

        $paymentTransaction = PaymentTransaction::fromOrder($order);

        $paymentTransaction = $this->p24->transaction(
            $paymentTransaction
        );
        $order->setToken($paymentTransaction->token());

        $this->transaction->begin();

        $this->orders->add($order);

        $this->transaction->end();


        return $paymentTransaction->redirectUrl();
    }
}