<?php

namespace App\Services\HearthAdoption;

use App\Core\Transactions\TransactionInterface;
use App\Entity\HearthAdoption\HearthAdoption;
use App\Models\HearthAdoption\UpdateHearthAdoptionModel;

class UpdateHearthAdoption
{
    public function __construct(
        private TransactionInterface $transaction
    ) {}

    public function update(HearthAdoption $hearthAdoption, UpdateHearthAdoptionModel $updateHearthAdoptionModel): void
    {
        $this->transaction->begin();

        $hearthAdoption->update(
            $updateHearthAdoptionModel->getChildren(),
            $updateHearthAdoptionModel->getMonthlyCost(),
            $updateHearthAdoptionModel->getContent(),
        );

        $this->transaction->end();
    }
}