<?php

namespace App\Services\Galleries;

use App\Core\File\FileRemover\FileRemoverInterface;
use App\Core\Transactions\TransactionInterface;
use App\Entity\Images\Image;
use App\Entity\Images\ImagesInterface;

class DeletePhoto
{
    public function __construct(
        private TransactionInterface $transaction,
        private FileRemoverInterface $fileRemover,
        private ImagesInterface $images
    ) {}

    public function delete(Image $image): void
    {
        $this->transaction->begin();

        $this->fileRemover->remove($image->getImage());
        $this->images->remove($image);

        $this->transaction->end();
    }
}