<?php

namespace App\ReportSystem;

use App\ReportSystem\Core\PreparedDataInterface;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Symfony\Component\HttpFoundation\File\Stream;

class ExcelGenerator
{
    private Spreadsheet $spreadsheet;
    private Worksheet $worksheet;

    public function __construct()
    {
        $this->spreadsheet = new Spreadsheet();
        $this->worksheet = $this->spreadsheet->getActiveSheet();
    }


    public function generateReport(PreparedDataInterface $preparedData): Stream
    {

        $this->worksheet->fromArray($preparedData->getData());

        $range = $this->worksheet->calculateWorksheetDimension();
        $this->worksheet->getStyle($range)->applyFromArray($preparedData->getStyles());


        $this->setAutoSize($this->worksheet);
        $filepath = $preparedData->getFilepath();
        $writer = new Xlsx($this->spreadsheet);
        $writer->save($filepath);

        return new Stream($filepath);
    }


    private function setAutoSize(Worksheet $sheet)
    {
        $cellIterator = $sheet->getRowIterator()->current()->getCellIterator();
        $cellIterator->setIterateOnlyExistingCells(true);

        foreach ($cellIterator as $cell) {
            $sheet->getColumnDimension($cell->getColumn())
                ->setAutoSize(true);
        }
    }

}