<?php

namespace App\PaymentSystem;

use App\PaymentSystem\Api\Response\CardChargeResponse;
use App\PaymentSystem\Api\Response\InfoTransactionResponse;
use App\PaymentSystem\Api\Response\RegisterTransactionResponse;
use App\PaymentSystem\Api\Response\VerifyTransactionResponse;

interface Przelewy24Interface
{
    public function transaction(PaymentTransaction $transaction): RegisterTransactionResponse;
    public function verify(TransactionVerification $verification): VerifyTransactionResponse;
    public function handleWebhook(): TransactionStatusNotification;
    public function handleCardInfo(): CardInfoNotification;
    public function cardCharge(TransactionCardCharge $cardCharge): CardChargeResponse;
    public function transactionBySessionId(string $sessionId): InfoTransactionResponse;
}