<?php

namespace App\PaymentSystem;

use InvalidArgumentException;

class Config
{
    /**
     * @var int
     */
    private $merchantId;

    /**
     * @var int|null
     */
    private $posId;

    /**
     * @var string
     */
    private $crc;

    /**
     * @var string
     */
    private $apiKey;

    /**
     * @var bool
     */
    private $isLiveMode;

    /**
     * @param string $merchantId
     * @param string $crc
     * @param bool $isLiveMode
     * @param string|null $posId
     */
    public function __construct(int $merchantId , string $crc, string $apiKey, bool $isLiveMode, ?int $posId = null)
    {
        $this->merchantId = $merchantId;
        $this->posId = $posId;
        $this->crc = $crc;
        $this->apiKey = $apiKey;
        $this->isLiveMode = $isLiveMode;
    }


    /**
     * @return int
     */
    public function getMerchantId(): int
    {
        return $this->merchantId;
    }

    /**
     * @return int
     */
    public function getPosId(): int
    {
        return $this->posId ?? $this->getMerchantId();
    }

    /**
     * @return string
     */
    public function getCrc(): string
    {
        return $this->crc;
    }

    /**
     * @return bool
     */
    public function isLiveMode(): bool
    {
        return $this->isLiveMode;
    }

    /**
     * @return string
     */
    public function getApiKey(): string
    {
        return $this->apiKey;
    }

    /**
     * @return array
     */
    public function toArray(): array
    {
        return [
            'merchantId' => $this->getMerchantId(),
            'posId' => $this->getPosId(),
            'crc' => $this->getCrc()
        ];
    }
}
