<?php

namespace App\PaymentSystem\Api\Request;

use App\PaymentSystem\Config;

class ApiRequest implements SignedApiRequest
{
    /**
     * @var array
     */
    protected $parameters = [];

    /**
     * @var array
     */
    protected $signatureAttributes = [];

    /**
     * @param Config $config
     * @return SignedApiRequest
     */
    public function setConfig(Config $config): SignedApiRequest
    {
        $this->parameters = array_merge($config->toArray(), $this->parameters);

        return $this;
    }

    /**
     * @return array
     */
    public function parameters(): array
    {
        $this->parameters['sign'] = $this->signature();

        return $this->parameters;
    }

    /**
     * @return string
     */
    public function signature(): string
    {
        $parameters = [];
        foreach ($this->signatureAttributes as $param) {
            $parameters[$param] = $this->parameters[$param];
        }

        return hash('sha384', json_encode($parameters, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));
    }

    /**
     * @param string $name
     * @return string
     */
    public function __get(string $name): string
    {
        return $this->parameters[$name];
    }

    /**
     * @param string $name
     * @param string $value
     */
    public function __set(string $name, string $value): void
    {
        $this->parameters[$name] = $value;
    }
}
