<?php

namespace App\Models\Posts;

use App\Core\File\FileToUpload\ImageToUpload;
use App\Core\ParamConverter\FormDataModelConverter;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\Validator\Constraints as Assert;

class PostModel implements FormDataModelConverter
{
    #[Assert\NotBlank]
    #[Assert\Type(type: 'string')]
    #[Assert\Length(max: 100)]
    private string $title;

    #[Assert\NotBlank]
    #[Assert\Type(type: 'string')]
    #[Assert\Length(max: 200)]
    private string $description;

    #[Assert\Valid]
    private ?ImageToUpload $photo = null;

    #[Assert\NotBlank]
    #[Assert\Type(type: 'string')]
    private string $content;

    /**
     * @return string
     */
    public function getTitle(): string
    {
        return $this->title;
    }

    /**
     * @param string $title
     */
    public function setTitle(string $title): void
    {
        $this->title = $title;
    }

    /**
     * @return ImageToUpload|null
     */
    public function getPhoto(): ?ImageToUpload
    {
        return $this->photo;
    }

    public function isPhoto(): bool
    {
        return !empty($this->photo);
    }

    /**
     * @param UploadedFile|string $photo
     */
    public function setPhoto(UploadedFile|string $photo): void
    {
        $this->photo = !empty($photo) ? new ImageToUpload($photo) : null;
    }

    /**
     * @return string
     */
    public function getDescription(): string
    {
        return $this->description;
    }

    /**
     * @param string $description
     */
    public function setDescription(string $description): void
    {
        $this->description = $description;
    }

    /**
     * @return string
     */
    public function getContent(): string
    {
        return $this->content;
    }

    /**
     * @param string $content
     */
    public function setContent(string $content): void
    {
        $this->content = $content;
    }
}