<?php

namespace App\Models\Orders;

use App\Core\ParamConverter\JsonModelConverter;
use Symfony\Component\Serializer\Annotation\Ignore;
use Symfony\Component\Validator\Constraints as Assert;

class RenewSubscriptionModel implements JsonModelConverter
{
    #[Assert\NotBlank]
    #[Assert\Positive]
    private int $months;

    #[Assert\Type(type: 'bool')]
    private bool $isUnitMonthlyCost;

    /**
     * @return int
     */
    public function getMonths(): int
    {
        return $this->months;
    }

    /**
     * @param int $months
     * @return RenewSubscriptionModel
     */
    public function setMonths(int $months): RenewSubscriptionModel
    {
        $this->months = $months;
        return $this;
    }

    /**
     * @return bool
     */
    #[Ignore]
    public function isUnitMonthlyCost(): bool
    {
        return $this->isUnitMonthlyCost;
    }

    /**
     * @param bool $isUnitMonthlyCost
     * @return RenewSubscriptionModel
     */
    public function setIsUnitMonthlyCost(bool $isUnitMonthlyCost): RenewSubscriptionModel
    {
        $this->isUnitMonthlyCost = $isUnitMonthlyCost;
        return $this;
    }
}