<?php

namespace App\Models\Orders;

use App\Entity\Users\User;
use Symfony\Component\Serializer\Annotation\Groups;
use Symfony\Component\Serializer\Annotation\Ignore;
use Symfony\Component\Validator\Constraints as Assert;

class OrderHearthAdoptionModel
{
    const CHILDREN_REQUIRED = 'children_required';
    const MONTHS_REQUIRED = 'months_required';

    #[Assert\NotBlank(groups: [self::CHILDREN_REQUIRED])]
    #[Assert\Positive(groups: [self::CHILDREN_REQUIRED])]
    #[Assert\Type(type: "integer", groups: [self::CHILDREN_REQUIRED])]
    private int $children;

    #[Assert\NotBlank(groups: [self::MONTHS_REQUIRED])]
    #[Assert\Positive(groups: [self::MONTHS_REQUIRED])]
    private ?int $months;

    private User $user;

    /**
     * @param int $children
     * @param int|null $months
     */
    public function __construct(int $children, ?int $months = null)
    {
        $this->children = $children;
        $this->months = $months;
    }

    /**
     * @return int
     */
    #[Groups([self::CHILDREN_REQUIRED])]
    public function getChildren(): int
    {
        return $this->children;
    }

    /**
     * @return int|null
     */
    #[Groups([self::MONTHS_REQUIRED])]
    public function getMonths(): ?int
    {
        return $this->months;
    }

    /**
     * @param User|null $user
     */
    public function setUser(?User $user)
    {
        $this->user = $user;
    }

    /**
     * @return User|null
     */
    #[Ignore]
    public function getUser(): ?User
    {
        return $this->user;
    }
}