<?php

namespace App\Models\HearthAdoption;

use App\Core\ParamConverter\JsonModelConverter;
use App\Core\Utils\Money;
use Symfony\Component\Validator\Constraints as Assert;

class UpdateHearthAdoptionModel implements JsonModelConverter
{
    #[Assert\NotBlank]
    #[Assert\Type(type: 'int')]
    #[Assert\Range(min: 0)]
    private int $children;

    /** @var float $monthlyCost */
    #[Assert\NotBlank]
    #[Assert\Type(type: 'float')]
    #[Assert\PositiveOrZero]
    private float $monthlyCost;

    #[Assert\NotBlank]
    #[Assert\Type(type: 'string')]
    private string $content;

    /**
     * @return int
     */
    public function getChildren(): int
    {
        return $this->children;
    }

    /**
     * @param int $children
     */
    public function setChildren(int $children): void
    {
        $this->children = $children;
    }

    /**
     * @return int
     */
    public function getMonthlyCost(): int
    {
        return Money::toMinor($this->monthlyCost);
    }

    /**
     * @param float $monthlyCost
     */
    public function setMonthlyCost(float $monthlyCost): void
    {
        $this->monthlyCost = $monthlyCost;
    }

    /**
     * @return string
     */
    public function getContent(): string
    {
        return $this->content;
    }

    /**
     * @param string $content
     */
    public function setContent(string $content): void
    {
        $this->content = $content;
    }
}