<?php

namespace App\Models\BalanceOperations;

use App\Core\ParamConverter\JsonModelConverter;
use App\Core\Utils\Money;
use Symfony\Component\Serializer\Annotation\Ignore;
use Symfony\Component\Validator\Constraints as Assert;

class CreateBalanceOperationModel implements JsonModelConverter
{
    #[Assert\NotBlank]
    #[Assert\Type(type: 'string')]
    #[Assert\Length(max: 100)]
    private string $title;

    /** @var float $monthlyCost */
    #[Assert\NotBlank]
    #[Assert\Type(type: 'float')]
    #[Assert\NotEqualTo(value: 0)]
    private float $price;

    /**
     * @return string
     */
    public function getTitle(): string
    {
        return $this->title;
    }

    /**
     * @return float
     */
    public function getPrice(): float
    {
        return $this->price;
    }

    /**
     * @return int
     */
    #[Ignore]
    public function getAmount(): int
    {
        return Money::toMinor($this->price);
    }

    /**
     * @param string $title
     * @return CreateBalanceOperationModel
     */
    public function setTitle(string $title): CreateBalanceOperationModel
    {
        $this->title = $title;
        return $this;
    }

    /**
     * @param float $price
     * @return CreateBalanceOperationModel
     */
    public function setPrice(float $price): CreateBalanceOperationModel
    {
        $this->price = $price;
        return $this;
    }
}