<?php

namespace App\Entity\Users\ReadModel;

use App\Core\Utils\FromArray;
use App\Entity\Users\User;
use App\Entity\Users\UserID;
use Symfony\Component\Serializer\Annotation\Groups;

class PersonalDataDTO
{
    use FromArray;

    public function __construct(
        private string $uuid,
        private string $name,
        private string $surname,
        private string $email,
        private ?string $referenceCode = null,
        private array $permissions = []
    )
    {
        $this->uuid = (string)UserID::fromString($this->uuid);
    }

    /**
     * @return string
     */
    public function getUuid(): string
    {
        return $this->uuid;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getSurname(): string
    {
        return $this->surname;
    }

    /**
     * @return string
     */
    public function getEmail(): string
    {
        return $this->email;
    }

    /**
     * @return array
     */
    public function getPermissions(): array
    {
        return $this->permissions;
    }

    /**
     * @return string|null
     */
    public function getReferenceCode(): ?string
    {
        return $this->referenceCode;
    }

    public static function fromUser(User $user): PersonalDataDTO
    {
        return new PersonalDataDTO(
            $user->getUuid(),
            $user->getName(),
            $user->getSurname(),
            $user->getEmail(),
            $user->getReferenceCode(),
            $user->getRoles()
        );
    }
}