<?php

namespace App\Entity\Users\Helper;

use App\Core\Utils\FromArray;
use App\Core\Utils\Money;
use App\Entity\BalanceOperations\BalanceOperationID;
use App\Entity\BalanceOperations\Helper\Type;
use Symfony\Component\Serializer\Annotation\Ignore;

class VolunteerBalanceHistoryDTO
{
    use FromArray;

    public function __construct(
        public string $balanceOperationID,
        public string $title,
        public string $type,
        public int $amount,
        public int $balance,
        public string $createdAt
    )
    {
        $this->balanceOperationID = (string)BalanceOperationID::fromString($this->balanceOperationID);
    }

    /**
     * @return string
     */
    public function getBalanceOperationID(): string
    {
        return $this->balanceOperationID;
    }

    /**
     * @return string
     */
    public function getTitle(): string
    {
        return $this->title;
    }

    /**
     * @return Type
     */
    public function getType(): Type
    {
        return new Type($this->type);
    }

    /**
     * @return float
     */
    public function getPrice(): float
    {
        return Money::toRational($this->amount);
    }

    /**
     * @return float
     */
    public function getBalance(): float
    {
        return Money::toRational($this->balance);
    }

    /**
     * @return string
     */
    public function getCreatedAt(): string
    {
        return $this->createdAt;
    }

}