<?php

namespace App\Entity\Users\Factory;

use App\Entity\Roles\Role;
use App\Entity\Users\User;
use App\Entity\Users\UserID;
use App\Models\Users\UserModel;

class UserFactory
{
    public function buildUser(UserModel $userModel, Role $role): User
    {
        $user = new User(
            UserID::generate(),
            $userModel->getName(),
            $userModel->getSurname(),
            $userModel->getEmail(),
            $role
        );
        $user->setPassword($userModel->getPassword());
        $user->generateToken();

        return $user;
    }
}