<?php

namespace App\Entity\Units\ReadModel;

use App\Core\Paginator\ObjectValue\PaginationRequest;
use App\Entity\Units\UnitID;
use App\Entity\Users\UserID;

interface UnitsQueryInterface
{
    /**
     * @param PaginationRequest $paginationRequest
     * @return UnitListDetailsDTO[]
     */
    public function findAllActiveUnits(PaginationRequest $paginationRequest): array;

    /**
     * @param PaginationRequest $paginationRequest
     * @return UnitAdminListDTO[]
     */
    public function findAllUnits(PaginationRequest $paginationRequest): array;

    /**
     * @param UnitID $unitID
     * @return UnitDataDTO|null
     */
    public function findUnitDataById(UnitID $unitID, ?UserID $userID): ?UnitDataDTO;

    /**
     * @param UnitID $unitID
     */
    public function findUnitDetailsByUnitId(UnitID $unitID): ?UnitDetailsDTO;


    /**
     *
     */
    public function findAllPossibilityChildren(UnitID $unitID): array;

    /**
     * @param UserID $userID
     * @return array
     */
    public function findAllUserUnitsToAssign(UserID $userID): array;
}