<?php

namespace App\Entity\Units\ReadModel;

use App\Core\Utils\FromArray;
use App\Core\Utils\Money;
use App\Entity\Units\UnitID;

class UnitListDetailsDTO
{
    use FromArray;

    private function __construct(
        private string $unitId,
        private string $photo,
        private string $title,
        private string $description,
        private string $type,
        private bool $isActive,
        private int $moneyPurpose,
        private ?int $collectedMoney = 0,
        private ?int $children = 0,
        private ?int $supportedChildren = 0,
        private int $monthlyCost = 0,
    ) {
        $this->unitId = (string) UnitID::fromString($this->unitId);
    }

    /**
     * @return string
     */
    public function getUnitId(): string
    {
        return $this->unitId;
    }

    /**
     * @return string
     */
    public function getPhoto(): string
    {
        return $this->photo;
    }

    /**
     * @return string
     */
    public function getTitle(): string
    {
        return $this->title;
    }

    /**
     * @return string
     */
    public function getDescription(): string
    {
        return $this->description;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @return bool
     */
    public function getIsActive(): bool
    {
        return $this->isActive;
    }

    /**
     * @return float
     */
    public function getMoneyPurpose(): float
    {
        return Money::toRational($this->moneyPurpose);
    }

    /**
     * @return int
     */
    public function getCollectedMoney(): float
    {
        return Money::toRational($this->collectedMoney);
    }

    /**
     * @return int|null
     */
    public function getChildren(): ?int
    {
        return $this->children;
    }

    /**
     * @return int|null
     */
    public function getSupportedChildren(): ?int
    {
        return $this->supportedChildren;
    }

    /**
     * @return float
     */
    public function getMonthlyCost(): float
    {
        return Money::toRational($this->monthlyCost);
    }
}