<?php

namespace App\Entity\Units\ReadModel;

use App\Core\Utils\FromArray;

class UnitDetailsDTO
{
    use FromArray;

    private function __construct(
        private string $type,
        private string $photo,
        private string $banner,
        private string $title,
        private string $description,
        private bool $hasParent,
    ) {}

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @return string
     */
    public function getTitle(): string
    {
        return $this->title;
    }

    /**
     * @return string
     */
    public function getPhoto(): string
    {
        return $this->photo;
    }

    /**
     * @return string
     */
    public function getBanner(): string
    {
        return $this->banner;
    }

    /**
     * @return string
     */
    public function getDescription(): string
    {
        return $this->description;
    }

    /**
     * @return bool
     */
    public function getHasParent(): bool
    {
        return $this->hasParent;
    }
}