<?php

namespace App\Entity\Units\ReadModel;

use App\Core\Utils\FromArray;
use App\Core\Utils\Money;
use App\Entity\Units\UnitID;

class UnitAdminListDTO
{
    use FromArray;

    private function __construct(
        private string $unitId,
        private string $unitTitle,
        private string $type,
        private string $purposeTitle,
        private int $moneyPurpose,
        private string $startedAt,
        private bool $isPublish,
        private ?string $publishedAt = null,
        private ?int $children = 0,
        private ?int $monthlyCost = 0
    ) {
        $this->unitId = (string) UnitID::fromString($this->unitId);
    }

    /**
     * @return string
     */
    public function getUnitId(): string
    {
        return $this->unitId;
    }

    /**
     * @return string
     */
    public function getUnitTitle(): string
    {
        return $this->unitTitle;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @return string
     */
    public function getPurposeTitle(): string
    {
        return $this->purposeTitle;
    }

    /**
     * @return float
     */
    public function getMoneyPurpose(): float
    {
        return Money::toRational($this->moneyPurpose);
    }

    /**
     * @return string
     */
    public function getStartedAt(): string
    {
        return $this->startedAt;
    }

    /**
     * @return bool
     */
    public function getIsPublish(): bool
    {
        return $this->isPublish;
    }

    /**
     * @return string|null
     */
    public function getPublishedAt(): ?string
    {
        return $this->publishedAt;
    }

    /**
     * @return int|null
     */
    public function getChildren(): ?int
    {
        return $this->children;
    }

    /**
     * @return float
     */
    public function getMonthlyCost(): float
    {
        return Money::toRational($this->monthlyCost);
    }
}