<?php

namespace App\Entity\Units\Factory;

use App\Core\Exception\ApiException;
use App\Entity\Contents\Factory\ContentFactory;
use App\Entity\HearthAdoption\Factory\HearthAdoptionFactory;
use App\Entity\Images\Factory\ImageFactory;
use App\Entity\Purposes\Factory\PurposeFactory;
use App\Entity\Units\Unit;
use App\Entity\Units\UnitsInterface;
use App\Models\Units\UnitModel;
use Symfony\Contracts\Translation\TranslatorInterface;

class UnitFactory
{
    public function __construct(
        private TranslatorInterface $translator,
        private UnitsInterface $units
    ) {}

    public function create(UnitModel $unitModel): Unit
    {
        $unit = new Unit(
            title: $unitModel->getTitle(),
            banner: ImageFactory::create($unitModel->getBanner()),
            photo: ImageFactory::create($unitModel->getPhoto()),
            description: $unitModel->getDescription(),
            cardInfo: ContentFactory::generateDefaultContent(),
            purpose: PurposeFactory::generateDefaultPurpose(),
            type: $unitModel->getUnitType()
        );

        if ($unitModel->getUnitType()->hasSubscriptionOrders()) {
            $unit->setHearthAdoption(
                HearthAdoptionFactory::generateDefaultAdoption()
            );
        }

        $this->addChildren($unit,$unitModel->getUnitChildren());

        return $unit;
    }

    private function addChildren(Unit $unit, array $children): void
    {
        if (!$unit->getType()->isEmergency() && !empty($children))
        {
            throw new ApiException($this->translator->trans('unit.unitChildren.type'));
        }

        $childrenToAdd = $this->units->findAllByIDs($children);
        foreach ($childrenToAdd as $child) {
            $unit->addUnitChildren($child);
        }
    }
}