<?php

namespace App\Entity\Sliders\ReadModel;

use App\Core\Utils\FromArray;
use App\Entity\SliderImages\ReadModel\SliderImageDTO;

class SliderDTO
{
    use FromArray;

    private function __construct(
        private int   $durationTime,
        private array $photos,

    )
    {
    }

    /**
     * @return int
     */
    public function getDurationTime(): int
    {
        return $this->durationTime;
    }

    /**
     * @return SliderImageDTO[]
     */
    public function getPhotos(): array
    {
        return $this->photos;
    }

}