<?php

namespace App\Entity\SliderImages;

use App\Entity\Sliders\SliderID;

interface SliderImagesInterface
{
    /**
     * @param SliderImage $sliderImage
     */
    public function add(SliderImage $sliderImage): void;

    /**
     * @param SliderImage $sliderImage
     */
    public function remove(SliderImage $sliderImage): void;


    /**
     * @param SliderID $sliderID
     * @param int $orderNumber
     * @return SliderImage[]
     */
    public function getSliderImagesWithOrderNumberBiggerThan(SliderID $sliderID, int $orderNumber): array;

    /**
     * @param array $sliderImageIDs
     * @return array
     */
    public function findAllByIDs(array $sliderImageIDs): array;
}