<?php

namespace App\Entity\SliderImages\ReadModel;

use App\Core\Utils\FromArray;
use App\Entity\SliderImages\SliderImageID;
use App\Entity\Units\UnitID;

class SliderImageDTO
{
    use FromArray;

    private function __construct(
        private string $photo,
        private string $photoId,
        private int $orderNumber,
        private ?string $unitId = null,
        private ?string $description = null,
        private ?string $title = null
    )
    {
        $this->photoId = (string) SliderImageID::fromString($photoId);
    }

    /**
     * @return string
     */
    public function getPhoto(): string
    {
        return $this->photo;
    }

    /**
     * @return string
     */
    public function getPhotoId(): string
    {
        return $this->photoId;
    }

    /**
     * @return int
     */
    public function getOrderNumber(): int
    {
        return $this->orderNumber;
    }

    /**
     * @return string|null
     */
    public function getUnitId(): ?string
    {
        return $this->unitId ? $this->unitId = (string) UnitID::fromString($this->unitId) : null;
    }

    /**
     * @return string|null
     */
    public function getDescription(): ?string
    {
        return $this->description;
    }

    /**
     * @return string|null
     */
    public function getTitle(): ?string
    {
        return $this->title;
    }
}