<?php

namespace App\Entity\SliderImages\Factory;

use App\Core\File\FileToUpload\FileToUploadInterface;
use App\Entity\SliderImages\SliderImage;
use App\Entity\SliderImages\SliderImageID;
use App\Entity\Sliders\ReadModel\SliderQueryInterface;
use App\Entity\Sliders\Slider;
use App\Entity\Sliders\SliderInterface;

class SliderImageFactory
{
    public function __construct(
        private SliderInterface $slider,
        private SliderQueryInterface $sliderQuery
    )
    {}

    public function create(FileToUploadInterface $fileToUpload): SliderImage
    {
        return new SliderImage(
            $this->slider->getSlider(),
            $fileToUpload->getUniqueName(),
            $this->sliderQuery->getLastOrderNumber() + 1);
    }
}