<?php

namespace App\Entity\Reports\ReadModel;

use App\Core\Utils\FromArray;
use App\Core\Utils\Money;
use App\Entity\Units\UnitID;

class YearReportDTO
{
    use FromArray;

    public function __construct(
        private string $unitId,
        private string $unitTitle,
        private int $totalMoney
    )
    {
        $this->unitId = (string)UnitID::fromString($this->unitId);
    }

    /**
     * @return string
     */
    public function getUnitId(): string
    {
        return $this->unitId;
    }

    /**
     * @return string
     */
    public function getUnitTitle(): string
    {
        return $this->unitTitle;
    }

    /**
     * @return float
     */
    public function getTotalMoney(): float
    {
        return Money::toRational($this->totalMoney);
    }


}